#include <bits/stdc++.h>
#define f first
#define s second
#define endl '\n'
#define len(a) (int)a.size()
#define all(a) a.begin(), a.end()
#define allr(a) a.rbegin(), a.rend()

using namespace std;
typedef long long ll;
typedef long double ld;
const ll INF = 1e18;
const int MAXI = 1e9 + 1e7;
const ll MOD = 1000000007;

struct pt {
    ll x, y;
    pt(ll _x = 0, ll _y = 0): x(_x), y(_y) {};
    pt(pt a, pt b): x(b.x - a.x), y(b.y - a.y) {};
    ll operator%(pt a) const { return x * a.y - y * a.x; }
    bool operator==(pt a) const { return x == a.x && y == a.y; }
};

bool axis_check(ll l1, ll r1, ll l2, ll r2) {
    if (l1 > r1)
        swap(l1, r1);
    if (l2 > r2)
        swap(l2, r2);
    return max(l1, l2) <= min(r1, r2);
}

int sign(ll a) {
    return (a > 0) - (a < 0);
}

bool intersect(pt a, pt b, pt c, pt d) {
    int s1 = sign(pt(a, b) % pt(a, c)), s2 = sign(pt(a, b) % pt(a, d));
    int s3 = sign(pt(c, d) % pt(c, a)), s4 = sign(pt(c, d) % pt(c, b));
    bool check1 = !(s1 && s2 && s1 == s2);
    bool check2 = !(s3 && s4 && s3 == s4);
    bool x_check = axis_check(a.x, b.x, c.x, d.x);
    bool y_check = axis_check(a.y, b.y, c.y, d.y);
    return check1 && check2 && x_check && y_check;
}

struct DSU {
    vector<int> p, sz;
    DSU(int n): p(n), sz(n, 1) {
        iota(all(p), 0);
    }
    int get(int a) {
        return p[a] = (p[a] == a ? a : get(p[a]));
    }
    void join(int a, int b) {
        a = get(a), b = get(b);
        if (a == b)
            return;
        if (sz[a] > sz[b])
            swap(a, b);
        p[a] = b;
        sz[b] += sz[a];
    }
};

int main() {
#ifdef MY_DEBUG
    freopen("../input.txt", "r", stdin);
    freopen("../output.txt", "w", stdout);
#endif
    int t;
    cin >> t;
    while (t--) {
        int n;
        cin >> n;
        vector<int> cnt(n);
        vector<pair<pt, pt> > seg(n);
        int v_cnt = 0;
        DSU dsu(n);
        for (int i = 0; i < n; i++) {
            cin >> seg[i].f.x >> seg[i].f.y >> seg[i].s.x >> seg[i].s.y;
            for (int j = i - 1; j >= 0; j--) {
                if (intersect(seg[i].f, seg[i].s, seg[j].f, seg[j].s)) {
                    dsu.join(i, j);
                    cnt[i]++, cnt[j]++;
                    v_cnt++;
                }
            }
        }
        int e_cnt = 0;
        for (int i = 0; i < n; i++)
            e_cnt += max(0, cnt[i] - 1);
        int comp_cnt = 0;
        for (int i = 0; i < n; i++) {
            if (dsu.get(i) == i && cnt[i])
                comp_cnt++;
        }
        if (!v_cnt)
            cout << 1 << endl;
        else
            cout << e_cnt - v_cnt + comp_cnt + 1 << endl;
    }
}
